/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSUDDIRegistry;
import filenet.ws.utils.WSValidateServerCertificate;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.BusinessInfos;
import org.apache.juddi.datatype.response.RegisteredInfo;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.datatype.response.TModelList;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.proxy.RegistryProxy;

public class WSUDDIPublishingRegistry {
    protected static Logger logger = Logger.getLogger("filenet.ws.api.uddi");
    protected static final String m_className = "WSUDDIPublishingRegistry";
    WSUDDIRegistry m_registry = null;
    RegistryProxy m_uddiProxy = null;
    AuthInfo m_authInfo = null;
    String m_username = null;
    Hashtable m_publishedBusinessEntities = new Hashtable();
    Vector m_publishedTModels = new Vector();
    Hashtable m_tModels = new Hashtable();
    RegisteredInfo m_registeredInfo = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.11  $";
    }

    public WSUDDIPublishingRegistry(WSUDDIRegistry registry) {
        this.m_registry = registry;
        if (this.m_registry != null) {
            this.m_uddiProxy = this.m_registry.getUDDIProxy();
            this.m_authInfo = this.m_registry.getAuthInfo();
            this.m_username = this.m_registry.getUsername();
        }
    }

    public static BusinessEntity newBussinessEntity(String name, String description) {
        BusinessEntity businessEntity = new BusinessEntity();
        Vector<Object> v = new Vector<Object>();
        v.add(new Name(name));
        businessEntity.setNameVector(v);
        v = new Vector();
        v.add(new Description(description));
        businessEntity.setDescriptionVector(v);
        return businessEntity;
    }

    public static BusinessService newBussinessService(String name, String description) {
        BusinessService businessService = new BusinessService();
        Vector<Object> v = new Vector<Object>();
        v.add(new Name(name));
        businessService.setNameVector(v);
        v = new Vector();
        v.add(new Description(description));
        businessService.setDescriptionVector(v);
        return businessService;
    }

    public static TModel newWSDLTModel(String name, String description, String WSDLURL) {
        TModel tModel = new TModel();
        tModel.setName(name);
        Vector<Description> v = new Vector<Description>();
        v.add(new Description(description));
        tModel.setDescriptionVector(v);
        OverviewDoc overviewDoc = new OverviewDoc();
        overviewDoc.setOverviewURL(WSDLURL);
        v = new Vector();
        v.add(new Description("WSDL link"));
        overviewDoc.setDescriptionVector(v);
        tModel.setOverviewDoc(overviewDoc);
        tModel.setTModelKey("");
        KeyedReference keyedReference = new KeyedReference("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4", "uddi-org:types", "wsdlSpec");
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(keyedReference);
        tModel.setCategoryBag(catBag);
        return tModel;
    }

    boolean isAuthorized(BusinessEntity business) throws RegistryException {
        boolean bAuthorized = false;
        if (this.m_registeredInfo != null) {
            bAuthorized = this.isAuthorized(business, false);
        }
        if (!bAuthorized) {
            bAuthorized = this.isAuthorized(business, true);
        }
        return bAuthorized;
    }

    boolean isAuthorized(BusinessEntity business, boolean bRefresh) throws RegistryException {
        String key = business.getBusinessKey();
        if (key != null && key.length() > 0 && this.m_uddiProxy != null && this.m_authInfo != null) {
            if (this.m_registeredInfo == null || bRefresh) {
                this.m_registeredInfo = this.getRegisteredInfo();
            }
            Vector infos = null;
            BusinessInfos businessInfos = this.m_registeredInfo.getBusinessInfos();
            if (businessInfos != null) {
                infos = businessInfos.getBusinessInfoVector();
            }
            if (infos != null && infos.size() > 0) {
                String aKey = null;
                for (int i = 0; i < infos.size(); ++i) {
                    if (infos.get(i) == null || !(infos.get(i) instanceof BusinessInfo) || !((aKey = ((BusinessInfo)infos.get(i)).getBusinessKey()) != null & aKey.compareToIgnoreCase(key) == 0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public RegisteredInfo getRegisteredInfo() throws RegistryException {
        if (this.m_registry != null) {
            return this.m_registry.getRegisteredInfo(this.m_authInfo);
        }
        return null;
    }

    boolean isAuthorized(TModel tModel) throws RegistryException {
        boolean bAuthorized = false;
        if (this.m_registeredInfo != null) {
            bAuthorized = this.isAuthorized(tModel, false);
        }
        if (!bAuthorized) {
            bAuthorized = this.isAuthorized(tModel, true);
        }
        return bAuthorized;
    }

    boolean isAuthorized(TModel tModel, boolean bRefresh) throws RegistryException {
        String key = tModel.getTModelKey();
        if (key != null && key.length() > 0 && this.m_uddiProxy != null && this.m_authInfo != null) {
            RegisteredInfo registeredInfo = this.getRegisteredInfo();
            Vector infos = null;
            TModelInfos tModelInfos = registeredInfo.getTModelInfos();
            if (tModelInfos != null) {
                infos = tModelInfos.getTModelInfoVector();
            }
            if (infos != null && infos.size() > 0) {
                String aKey = null;
                for (int i = 0; i < infos.size(); ++i) {
                    if (infos.get(i) == null || !(infos.get(i) instanceof TModelInfo) || !((aKey = ((TModelInfo)infos.get(i)).getTModelKey()) != null & aKey.compareToIgnoreCase(key) == 0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    BusinessEntity[] findBusinessByName(String name) throws Exception {
        WSBusinessEntity[] businesses = this.m_registry.findBusinessByName(name);
        this.m_registry.getAuthInfo();
        if (businesses != null && businesses.length > 0) {
            Vector<BusinessEntity> businessVector = new Vector<BusinessEntity>();
            String username = this.m_registry.getUsername();
            BusinessEntity[] businessEntities = null;
            BusinessEntity business = null;
            for (int i = 0; i < businesses.length; ++i) {
                if (businesses == null || !this.isAuthorized(business = businesses[i].getBusinessEntity())) continue;
                businessVector.add(business);
            }
            if (businessVector != null && businessVector.size() > 0) {
                businessEntities = new BusinessEntity[businessVector.size()];
                businessVector.toArray(businessEntities);
                businessVector.clear();
            }
            return businessEntities;
        }
        return null;
    }

    public BusinessEntity publishBusinessEntity(BusinessEntity businessEntity) throws Exception {
        String key = null;
        PublishedBusinessEntity business = null;
        if (this.m_uddiProxy != null && businessEntity != null) {
            key = businessEntity.getBusinessKey();
            if (key == null || key.length() <= 0) {
                businessEntity.setBusinessKey("");
            } else {
                business = (PublishedBusinessEntity)this.m_publishedBusinessEntities.get(key);
            }
            if (business == null) {
                business = new PublishedBusinessEntity(this, businessEntity);
            }
            business.be_publishBusinessEntity();
            key = business.be_getKey();
            if (key != null && key.length() > 0) {
                this.m_publishedBusinessEntities.put(key, business);
            }
        }
        if (business != null) {
            return business.be_getBusinessEntity();
        }
        return null;
    }

    public PublishedBusinessEntity getPublishedBusinessEntitity(String key) {
        Object obj;
        if (key != null && (obj = this.m_publishedBusinessEntities.get(key)) != null && obj instanceof PublishedBusinessEntity) {
            return (PublishedBusinessEntity)obj;
        }
        return null;
    }

    public void publishBusinessService(WSBusinessEntity wsBusinessEntity, String serviceName, String description, String[] portTypes, String[] bindingDescriptions, String[] accessPoints, String[] tModelKeys) throws Exception {
        String businessKey = wsBusinessEntity.getBusinessKey();
        if (businessKey == null || businessKey.length() <= 0) {
            return;
        }
        PublishedBusinessEntity business = this.getPublishedBusinessEntitity(businessKey);
        if (business == null) {
            business = new PublishedBusinessEntity(this, wsBusinessEntity.getBusinessEntity());
            this.m_publishedBusinessEntities.put(businessKey, business);
        }
        if (business != null && serviceName != null) {
            BusinessService service = WSUDDIPublishingRegistry.newBussinessService(serviceName, description);
            business.be_publishBusinessService(service, portTypes, bindingDescriptions, accessPoints, tModelKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServiceRelatedTModels(WSBusinessEntity wsBusinessEntity, String serviceName) throws Exception {
        String m_method = "deleteServiceRelatedTModels";
        logger.entering(m_className, m_method);
        try {
            if (serviceName != null && serviceName.length() > 0) {
                String[] serviceNames = new String[]{serviceName};
                this.deleteServiceRelatedTModels(wsBusinessEntity, serviceNames);
            }
            Object var6_5 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServiceRelatedTModels(WSBusinessEntity wsBusinessEntity, String[] serviceNames) throws Exception {
        String m_method = "deleteServiceRelatedTModels";
        logger.entering(m_className, m_method);
        try {
            String businessKey;
            block9: {
                block8: {
                    businessKey = wsBusinessEntity.getBusinessKey();
                    if (businessKey == null) break block8;
                    if (businessKey.length() > 0) break block9;
                }
                Object var7_5 = null;
                logger.exiting(m_className, m_method);
                return;
            }
            PublishedBusinessEntity business = this.getPublishedBusinessEntitity(businessKey);
            if (business == null) {
                business = new PublishedBusinessEntity(this, wsBusinessEntity.getBusinessEntity());
                this.m_publishedBusinessEntities.put(businessKey, business);
            }
            if (business != null) {
                business.be_deleteServiceRelatedTModels(serviceNames);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
        Object var7_6 = null;
        logger.exiting(m_className, m_method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServiceWithSameName(WSBusinessEntity wsBusinessEntity, Vector serviceVector) throws Exception {
        String m_method = "deleteServiceWithSameName";
        logger.entering(m_className, m_method);
        try {
            String businessKey;
            block9: {
                block8: {
                    businessKey = wsBusinessEntity.getBusinessKey();
                    if (businessKey == null) break block8;
                    if (businessKey.length() > 0) break block9;
                }
                Object var7_5 = null;
                logger.exiting(m_className, m_method);
                return;
            }
            PublishedBusinessEntity business = this.getPublishedBusinessEntitity(businessKey);
            if (business == null) {
                business = new PublishedBusinessEntity(this, wsBusinessEntity.getBusinessEntity());
                this.m_publishedBusinessEntities.put(businessKey, business);
            }
            if (business != null) {
                business.be_deleteExistingServicesWithSameName(serviceVector);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
        Object var7_6 = null;
        logger.exiting(m_className, m_method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTModels(String[] names) throws Exception {
        String m_method = "deleteTModels";
        logger.entering(m_className, m_method);
        try {
            TModelDetail tModelDetail;
            Vector keys;
            if (names != null && names.length > 0 && (keys = this.getTModelKeys(names)) != null && keys.size() > 0 && (tModelDetail = this.m_uddiProxy.getTModelDetail(keys)) != null) {
                Vector tModels = tModelDetail.getTModelVector();
                Object obj = null;
                TModel tModel = null;
                Vector<String> keyVector = new Vector<String>();
                for (int i = 0; i > tModels.size(); ++i) {
                    obj = tModels.get(i);
                    if (obj == null || !(obj instanceof TModel) || !this.isAuthorized(tModel = (TModel)obj)) continue;
                    keyVector.add(tModel.getTModelKey());
                }
                if (keyVector != null && keyVector.size() > 0) {
                    this.m_uddiProxy.deleteTModel(this.m_authInfo, keyVector);
                }
            }
            Object var11_10 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishTModel(Vector tModelVector) throws Exception {
        String m_method = "publishTModel";
        logger.entering(m_className, m_method);
        try {
            Vector tModels;
            TModelDetail tModelDetail;
            if (this.m_uddiProxy != null && tModelVector != null && tModelVector.size() > 0 && (tModelDetail = this.m_uddiProxy.saveTModel(this.m_authInfo, tModelVector)) != null && (tModels = tModelDetail.getTModelVector()) != null && tModels.size() > 0) {
                this.m_publishedTModels.addAll(tModels);
                Object obj = null;
                TModel tModel = null;
                for (int i = 0; i < tModels.size(); ++i) {
                    obj = tModels.get(i);
                    if (obj == null || !(obj instanceof TModel) || (tModel = (TModel)obj).getName() == null) continue;
                    this.m_tModels.put(tModel.getName(), tModel);
                }
            }
            Object var9_8 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String publishTModel(String name, String description, String wsdlLink) throws Exception {
        String m_method;
        block3: {
            m_method = "publishTModel";
            logger.entering(m_className, m_method);
            try {
                Object obj;
                TModel tModel = WSUDDIPublishingRegistry.newWSDLTModel(name, description, wsdlLink);
                if (tModel == null) break block3;
                Vector tModels = new Vector();
                tModels.add(tModel);
                tModels = this.publishTModels(tModels);
                if (tModels == null || tModels.size() != 1 || (obj = tModels.get(0)) == null || !(obj instanceof TModel)) break block3;
                String string = ((TModel)obj).getTModelKey();
                Object var10_9 = null;
                logger.exiting(m_className, m_method);
                return string;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
        String string = null;
        Object var10_10 = null;
        logger.exiting(m_className, m_method);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector publishTModels(Vector tModelVector) throws Exception {
        String m_method;
        block5: {
            m_method = "publishTModels";
            logger.entering(m_className, m_method);
            try {
                TModelDetail tModelDetail;
                if (this.m_uddiProxy == null || tModelVector == null || tModelVector.size() <= 0 || (tModelDetail = this.m_uddiProxy.saveTModel(this.m_authInfo, tModelVector)) == null) break block5;
                Vector tModels = tModelDetail.getTModelVector();
                if (tModels != null && tModels.size() > 0) {
                    this.m_publishedTModels.addAll(tModels);
                    Object obj = null;
                    TModel tModel = null;
                    for (int i = 0; i < tModels.size(); ++i) {
                        obj = tModels.get(i);
                        if (obj == null || !(obj instanceof TModel) || (tModel = (TModel)obj).getName() == null) continue;
                        this.m_tModels.put(tModel.getName(), tModel);
                    }
                }
                Vector vector = tModels;
                Object var9_8 = null;
                logger.exiting(m_className, m_method);
                return vector;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
        Vector vector = null;
        Object var9_9 = null;
        logger.exiting(m_className, m_method);
        return vector;
    }

    Vector getPublishedTModel() {
        return this.m_publishedTModels;
    }

    TModel getTModel(String name) {
        if (name != null) {
            return (TModel)this.m_tModels.get(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getTModelKey(String tModelName) throws Exception {
        String m_method;
        block8: {
            block7: {
                m_method = "getTModelKey";
                logger.entering(m_className, m_method);
                try {
                    if (tModelName != null) break block7;
                    String string = null;
                    Object var12_5 = null;
                    logger.exiting(m_className, m_method);
                    return string;
                }
                catch (Throwable throwable) {
                    Object var12_8 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            TModel tModel = this.getTModel(tModelName);
            if (tModel == null) break block8;
            String string = tModel.getTModelKey();
            Object var12_6 = null;
            logger.exiting(m_className, m_method);
            return string;
        }
        FindQualifiers findQualifiers = new FindQualifiers();
        Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
        qualifier.add(new FindQualifier("caseSensitiveMatch"));
        findQualifiers.setFindQualifierVector(qualifier);
        TModelList tModelList = null;
        TModelInfos tModelInfos = null;
        TModelInfo tModelInfo = null;
        String tModelKey = null;
        tModelList = this.m_uddiProxy.findTModel(tModelName, null, null, findQualifiers, 1);
        if (tModelList != null) {
            Vector v;
            tModelInfos = tModelList.getTModelInfos();
            if (tModelInfos != null && (v = tModelInfos.getTModelInfoVector()) != null && v.size() > 0 && v.get(0) instanceof TModelInfo) {
                tModelInfo = (TModelInfo)v.get(0);
            }
            if (tModelInfo != null) {
                tModelKey = tModelInfo.getTModelKey();
            }
        }
        String string = tModelKey;
        Object var12_7 = null;
        logger.exiting(m_className, m_method);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getTModelKeys(String[] tModelNames) throws Exception {
        String m_method;
        block7: {
            block6: {
                m_method = "getTModelKeys";
                logger.entering(m_className, m_method);
                if (tModelNames != null) break block6;
                Vector vector = null;
                Object var14_5 = null;
                logger.exiting(m_className, m_method);
                return vector;
            }
            try {
                Vector<String> tModelKeysVector = new Vector<String>();
                FindQualifiers findQualifiers = new FindQualifiers();
                Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
                qualifier.add(new FindQualifier("caseSensitiveMatch"));
                findQualifiers.setFindQualifierVector(qualifier);
                TModelList tModelList = null;
                TModelInfos tModelInfos = null;
                TModelInfo tModelInfo = null;
                String tModelKey = null;
                Vector v = null;
                for (int i = 0; i < tModelNames.length; ++i) {
                    if (tModelNames[i] == null || (tModelList = this.m_uddiProxy.findTModel(tModelNames[i], null, null, findQualifiers, 100)) == null || (tModelInfos = tModelList.getTModelInfos()) == null || (v = tModelInfos.getTModelInfoVector()) == null || v.size() <= 0) continue;
                    for (int j = 0; j < v.size(); ++j) {
                        if (v.get(j) == null || !(v.get(j) instanceof TModelInfo) || (tModelInfo = (TModelInfo)v.get(j)) == null || (tModelKey = tModelInfo.getTModelKey()) == null || tModelKey.length() <= 0) continue;
                        tModelKeysVector.add(tModelKey);
                    }
                }
                if (tModelKeysVector.size() <= 0) break block7;
                Vector<String> vector = tModelKeysVector;
                Object var14_6 = null;
                logger.exiting(m_className, m_method);
                return vector;
            }
            catch (Throwable throwable) {
                Object var14_8 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
        Vector vector = null;
        Object var14_7 = null;
        logger.exiting(m_className, m_method);
        return vector;
    }

    class PublishedBusinessEntity {
        protected static final String m_className = "WSUDDIPublishingRegistry.PublishedBusinessEntity";
        WSUDDIPublishingRegistry m_publishingRegistry = null;
        WSUDDIRegistry m_registry = null;
        RegistryProxy m_uddiProxy = null;
        AuthInfo m_authInfo = null;
        String m_name = null;
        BusinessEntity m_businessEntity = null;
        String m_key = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PublishedBusinessEntity(WSUDDIPublishingRegistry registry, BusinessEntity businessEntity) throws Exception {
            String m_method = "Ctor";
            logger.entering(m_className, m_method);
            try {
                this.m_publishingRegistry = registry;
                if (this.m_publishingRegistry != null) {
                    this.m_registry = this.m_publishingRegistry.m_registry;
                }
                if (this.m_registry != null) {
                    this.m_uddiProxy = this.m_registry.getUDDIProxy();
                    this.m_authInfo = this.m_registry.getAuthInfo();
                    if (businessEntity != null) {
                        String key = businessEntity.getBusinessKey();
                        if (key == null) {
                            key = new String("");
                            businessEntity.setBusinessKey(key);
                        }
                        this.m_businessEntity = businessEntity;
                        if (this.m_businessEntity != null) {
                            Vector v = this.m_businessEntity.getNameVector();
                            if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                                this.m_name = ((Name)v.get(0)).getValue();
                            }
                            this.m_key = this.m_businessEntity.getBusinessKey();
                        }
                    }
                }
                Object var8_7 = null;
                logger.exiting(m_className, m_method);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BusinessEntity be_publishBusinessEntity() throws Exception {
            String m_method;
            block4: {
                m_method = "be_publishBusinessEntity";
                logger.entering(m_className, m_method);
                try {
                    if (this.m_uddiProxy == null || this.m_businessEntity == null) break block4;
                    Vector<BusinessEntity> v = new Vector<BusinessEntity>();
                    v.add(this.m_businessEntity);
                    WSValidateServerCertificate.useProcessTrustStore();
                    BusinessDetail businessDetail = this.m_uddiProxy.saveBusiness(this.m_authInfo, v);
                    WSValidateServerCertificate.useDefaultTrustStore();
                    if (businessDetail == null) break block4;
                    Object obj = null;
                    Object key = null;
                    Object business = null;
                    Vector businessVector = businessDetail.getBusinessEntityVector();
                    if (businessVector == null || businessVector.size() <= 0 || (obj = businessVector.get(0)) == null || !(obj instanceof BusinessEntity)) break block4;
                    this.m_businessEntity = obj;
                    this.m_key = this.m_businessEntity.getBusinessKey();
                    Vector names = this.m_businessEntity.getNameVector();
                    if (names != null && names.get(0) != null && names.get(0) instanceof Name) {
                        this.m_name = ((Name)names.get(0)).getValue().trim();
                    }
                    BusinessEntity businessEntity = this.m_businessEntity;
                    Object var11_10 = null;
                    logger.exiting(m_className, m_method);
                    return businessEntity;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            BusinessEntity businessEntity = null;
            Object var11_11 = null;
            logger.exiting(m_className, m_method);
            return businessEntity;
        }

        public BusinessEntity be_getBusinessEntity() {
            return this.m_businessEntity;
        }

        public String be_getName() {
            return this.m_name;
        }

        public String be_getKey() {
            return this.m_key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector be_findExistingServiceKeysByName(BusinessService service) throws Exception {
            String m_method;
            block10: {
                BusinessServices services;
                Vector v;
                String name;
                block9: {
                    block8: {
                        m_method = "be_findExistingServiceKeysByName";
                        logger.entering(m_className, m_method);
                        name = null;
                        v = service.getNameVector();
                        if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                            name = ((Name)v.get(0)).getValue();
                        }
                        if (name != null) break block8;
                        Vector vector = null;
                        Object var13_7 = null;
                        logger.exiting(m_className, m_method);
                        return vector;
                    }
                    services = this.m_businessEntity.getBusinessServices();
                    if (services != null) break block9;
                    Vector vector = null;
                    Object var13_8 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                try {
                    String aName = null;
                    Object obj = null;
                    BusinessService s = null;
                    Vector<String> matchedServices = new Vector<String>();
                    Vector serviceVector = services.getBusinessServiceVector();
                    if (serviceVector == null || serviceVector.size() <= 0) break block10;
                    for (int i = 0; i < serviceVector.size(); ++i) {
                        obj = serviceVector.get(i);
                        if (obj == null || !(obj instanceof BusinessService)) continue;
                        s = obj;
                        v = s.getNameVector();
                        if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                            aName = ((Name)v.get(0)).getValue();
                        }
                        if (aName == null || aName.compareTo(name) != 0) continue;
                        matchedServices.add(s.getServiceKey());
                    }
                    if (matchedServices.size() <= 0) break block10;
                    Vector<String> vector = matchedServices;
                    Object var13_9 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                catch (Throwable throwable) {
                    Object var13_11 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            Vector vector = null;
            Object var13_10 = null;
            logger.exiting(m_className, m_method);
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector be_findExistingServiceKeysByName(Vector services) throws Exception {
            String m_method;
            block6: {
                block5: {
                    m_method = "be_findExistingServiceKeysByName";
                    logger.entering(m_className, m_method);
                    if (services != null && services.size() != 0) break block5;
                    Vector vector = null;
                    Object var8_5 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                try {
                    Object obj = null;
                    Vector keys = null;
                    Vector allKeys = new Vector();
                    for (int i = 0; i < services.size(); ++i) {
                        obj = services.get(i);
                        if (obj == null || !(obj instanceof BusinessService) || (keys = this.be_findExistingServiceKeysByName((BusinessService)obj)) == null || keys.size() <= 0) continue;
                        allKeys.addAll(keys);
                    }
                    if (allKeys.size() <= 0) break block6;
                    Vector vector = allKeys;
                    Object var8_6 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            Vector vector = null;
            Object var8_7 = null;
            logger.exiting(m_className, m_method);
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void be_deleteExistingServicesWithSameName(Vector services) throws Exception {
            String m_method = "be_deleteExistingServicesWithSameName";
            logger.entering(m_className, m_method);
            try {
                Vector keys = this.be_findExistingServiceKeysByName(services);
                if (keys != null && keys.size() > 0) {
                    this.m_uddiProxy.deleteService(this.m_authInfo, keys);
                }
                Object var5_4 = null;
                logger.exiting(m_className, m_method);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void be_publishBusinessService(BusinessService service) throws Exception {
            String m_method = "be_publishBusinessService";
            logger.entering(m_className, m_method);
            try {
                Vector<BusinessService> serviceVector = new Vector<BusinessService>();
                serviceVector.add(service);
                this.be_deleteExistingServicesWithSameName(serviceVector);
                if (service.getServiceKey() != null) {
                    service.setServiceKey(null);
                }
                this.m_uddiProxy.saveService(this.m_authInfo, serviceVector);
                Object var5_4 = null;
                logger.exiting(m_className, m_method);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TModelInstanceDetails be_newTModelInstanceDetails(String tModelKey) {
            String m_method = "be_newTModelInstanceDetails";
            logger.entering(m_className, m_method);
            try {
                TModelInstanceDetails details = new TModelInstanceDetails();
                TModelInstanceInfo info = new TModelInstanceInfo(tModelKey);
                details.addTModelInstanceInfo(info);
                TModelInstanceDetails tModelInstanceDetails = details;
                Object var7_6 = null;
                logger.exiting(m_className, m_method);
                return tModelInstanceDetails;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void be_publishBusinessService(BusinessService service, String[] portTypes, String[] bindingDescriptions, String[] accessPoints, String[] tModelKeys) throws Exception {
            String m_method = "be_publishBusinessService";
            logger.entering(m_className, m_method);
            try {
                if (service == null || portTypes == null || accessPoints == null || portTypes.length != accessPoints.length) {
                    new VWException("filenet.ws.api.uddi.invalidParameters", "Invalid parameters");
                }
                Vector<BusinessService> serviceVector = new Vector<BusinessService>();
                serviceVector.add(service);
                this.be_deleteExistingServicesWithSameName(serviceVector);
                service.setServiceKey("");
                service.setBusinessKey(this.m_key);
                Vector<Description> v = new Vector<Description>();
                String portTypeName = null;
                TModelInstanceDetails tModelInstanceDetails = null;
                BindingTemplates bindingTemplates = new BindingTemplates();
                BindingTemplate bindingTemplate = null;
                for (int i = 0; i < portTypes.length; ++i) {
                    portTypeName = portTypes[i];
                    if (portTypes[i] == null || accessPoints[i] == null) continue;
                    tModelInstanceDetails = this.be_newTModelInstanceDetails(tModelKeys[i]);
                    bindingTemplate = new BindingTemplate();
                    bindingTemplate.setAccessPoint(new AccessPoint("http", accessPoints[i]));
                    bindingTemplate.setTModelInstanceDetails(tModelInstanceDetails);
                    v = new Vector();
                    v.add(new Description(bindingDescriptions[i]));
                    if (i < bindingDescriptions.length && bindingDescriptions[i] != null) {
                        bindingTemplate.setDescriptionVector(v);
                    }
                    bindingTemplates.addBindingTemplate(bindingTemplate);
                }
                service.setBindingTemplates(bindingTemplates);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Save service...");
                }
                this.m_uddiProxy.saveService(this.m_authInfo, serviceVector);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Service saved");
                }
                Object var15_14 = null;
                logger.exiting(m_className, m_method);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void be_publishBusinessService(Vector serviceVector) throws Exception {
            String m_method = "be_publishBusinessService";
            logger.entering(m_className, m_method);
            try {
                this.be_deleteExistingServicesWithSameName(serviceVector);
                Object obj = null;
                BusinessService service = null;
                for (int i = 0; i < serviceVector.size(); ++i) {
                    obj = serviceVector.get(i);
                    if (obj == null || !(obj instanceof BusinessService)) continue;
                    service = obj;
                    service.setServiceKey("");
                    service.setBusinessKey(this.m_key);
                }
                this.m_uddiProxy.saveService(this.m_authInfo, serviceVector);
                Object var7_6 = null;
                logger.exiting(m_className, m_method);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector be_getServicesWithSameName(BusinessService service) throws Exception {
            String name;
            String m_method;
            block6: {
                block5: {
                    m_method = "be_getServicesWithSameName";
                    logger.entering(m_className, m_method);
                    try {
                        if (service != null) break block5;
                        Vector vector = null;
                        Object var7_5 = null;
                        logger.exiting(m_className, m_method);
                        return vector;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        logger.exiting(m_className, m_method);
                        throw throwable;
                    }
                }
                name = null;
                Vector v = service.getNameVector();
                if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                    name = ((Name)v.get(0)).getValue();
                }
                if (name != null) break block6;
                Vector vector = null;
                Object var7_6 = null;
                logger.exiting(m_className, m_method);
                return vector;
            }
            Vector vector = this.be_getServicesWithSameName(name);
            Object var7_7 = null;
            logger.exiting(m_className, m_method);
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector be_getServicesWithSameName(String name) throws Exception {
            String m_method;
            block9: {
                BusinessServices services;
                block8: {
                    block7: {
                        m_method = "be_getServicesWithSameName";
                        logger.entering(m_className, m_method);
                        if (name != null) break block7;
                        Vector vector = null;
                        Object var12_5 = null;
                        logger.exiting(m_className, m_method);
                        return vector;
                    }
                    services = this.m_businessEntity.getBusinessServices();
                    if (services != null) break block8;
                    Vector vector = null;
                    Object var12_6 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                try {
                    String aName = null;
                    Object obj = null;
                    Vector v = null;
                    BusinessService s = null;
                    Vector<BusinessService> matchedServices = new Vector<BusinessService>();
                    Vector serviceVector = services.getBusinessServiceVector();
                    if (serviceVector == null || serviceVector.size() <= 0) break block9;
                    for (int i = 0; i < serviceVector.size(); ++i) {
                        obj = serviceVector.get(i);
                        if (obj == null || !(obj instanceof BusinessService)) continue;
                        s = obj;
                        v = s.getNameVector();
                        if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                            aName = ((Name)v.get(0)).getValue();
                        }
                        if (aName == null || aName.compareTo(name) != 0) continue;
                        matchedServices.add(s);
                    }
                    if (matchedServices.size() <= 0) break block9;
                    Vector<BusinessService> vector = matchedServices;
                    Object var12_7 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                catch (Throwable throwable) {
                    Object var12_9 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            Vector vector = null;
            Object var12_8 = null;
            logger.exiting(m_className, m_method);
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector be_getServicesWithSameName(Vector serviceVector) throws Exception {
            String m_method;
            block6: {
                block5: {
                    m_method = "be_getServicesWithSameName";
                    logger.entering(m_className, m_method);
                    if (serviceVector != null && serviceVector.size() != 0) break block5;
                    Vector vector = null;
                    Object var8_5 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                try {
                    Vector all = new Vector();
                    Vector services = null;
                    for (int i = 0; i < serviceVector.size(); ++i) {
                        Object obj = serviceVector.get(i);
                        if (obj == null || !(obj instanceof BusinessService) || (services = this.be_getServicesWithSameName((BusinessService)obj)) == null || services.size() <= 0) continue;
                        all.addAll(services);
                    }
                    if (all == null || all.size() <= 0) break block6;
                    Vector vector = all;
                    Object var8_6 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            Vector vector = null;
            Object var8_7 = null;
            logger.exiting(m_className, m_method);
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector be_getServicesWithSameName(String[] serviceNames) throws Exception {
            String m_method;
            block6: {
                block5: {
                    m_method = "be_getServicesWithSameName";
                    logger.entering(m_className, m_method);
                    if (serviceNames != null && serviceNames.length != 0) break block5;
                    Vector vector = null;
                    Object var8_5 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                try {
                    Vector all = new Vector();
                    Vector services = null;
                    for (int i = 0; i < serviceNames.length; ++i) {
                        if (serviceNames[i] == null || (services = this.be_getServicesWithSameName(serviceNames[i])) == null || services.size() <= 0) continue;
                        all.addAll(services);
                    }
                    if (all == null || all.size() <= 0) break block6;
                    Vector vector = all;
                    Object var8_6 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            Vector vector = null;
            Object var8_7 = null;
            logger.exiting(m_className, m_method);
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector be_getTModelKeysFromServices(Vector serviceVector) throws Exception {
            String m_method;
            block8: {
                Vector services;
                block7: {
                    m_method = "be_getTModelKeysFromServices";
                    logger.entering(m_className, m_method);
                    services = this.be_getServicesWithSameName(serviceVector);
                    if (services != null && services.size() != 0) break block7;
                    Vector vector = null;
                    Object var18_6 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                try {
                    BusinessService service = null;
                    Vector<String> keys = new Vector<String>();
                    String key = null;
                    BindingTemplates bindingTemplates = null;
                    BindingTemplate bindingTemplate = null;
                    Vector bindingTemplateVector = null;
                    TModelInstanceDetails instDetails = null;
                    TModelInstanceInfo instInfo = null;
                    Vector instInfoVector = null;
                    for (int i = 0; i < services.size(); ++i) {
                        Object obj = serviceVector.get(i);
                        if (obj == null || !(obj instanceof BusinessService) || (bindingTemplates = (service = (BusinessService)obj).getBindingTemplates()) == null || (bindingTemplateVector = bindingTemplates.getBindingTemplateVector()) == null || bindingTemplateVector.size() == 0) continue;
                        for (int j = 0; j < bindingTemplateVector.size(); ++j) {
                            obj = bindingTemplateVector.get(j);
                            if (obj == null || !(obj instanceof BindingTemplate) || (instDetails = (bindingTemplate = (BindingTemplate)obj).getTModelInstanceDetails()) == null || (instInfoVector = instDetails.getTModelInstanceInfoVector()) == null || instInfoVector.size() == 0) continue;
                            for (int k = 0; k < instInfoVector.size(); ++k) {
                                obj = instInfoVector.get(k);
                                if (obj == null || !(obj instanceof TModelInstanceInfo) || (key = (instInfo = (TModelInstanceInfo)obj).getTModelKey()) == null || key.length() <= 0) continue;
                                keys.add(key);
                            }
                        }
                    }
                    if (keys.size() <= 0) break block8;
                    Vector<String> vector = keys;
                    Object var18_7 = null;
                    logger.exiting(m_className, m_method);
                    return vector;
                }
                catch (Throwable throwable) {
                    Object var18_9 = null;
                    logger.exiting(m_className, m_method);
                    throw throwable;
                }
            }
            Vector vector = null;
            Object var18_8 = null;
            logger.exiting(m_className, m_method);
            return vector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void be_deleteServiceRelatedTModels(Vector serviceVector) throws Exception {
            String m_method = "be_deleteServiceRelatedTModels";
            logger.entering(m_className, m_method);
            try {
                Vector services = this.be_getServicesWithSameName(serviceVector);
                Vector tmodelKeys = this.be_getTModelKeysFromServices(services);
                if (tmodelKeys != null && tmodelKeys.size() > 0) {
                    this.m_uddiProxy.deleteTModel(this.m_authInfo, tmodelKeys);
                }
                Object var6_5 = null;
                logger.exiting(m_className, m_method);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void be_deleteServiceRelatedTModels(String[] serviceNames) throws Exception {
            String m_method = "be_deleteServiceRelatedTModels";
            logger.entering(m_className, m_method);
            try {
                Vector services;
                block8: {
                    block7: {
                        services = this.be_getServicesWithSameName(serviceNames);
                        if (services == null) break block7;
                        if (services.size() != 0) break block8;
                    }
                    Object var6_4 = null;
                    logger.exiting(m_className, m_method);
                    return;
                }
                Vector tmodelKeys = this.be_getTModelKeysFromServices(services);
                if (tmodelKeys != null && tmodelKeys.size() > 0) {
                    this.m_uddiProxy.deleteTModel(this.m_authInfo, tmodelKeys);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
            Object var6_5 = null;
            logger.exiting(m_className, m_method);
        }
    }
}

